/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.nickhider;

import club.sk1er.nickhider.NickHiderConfig;
import club.sk1er.nickhider.command.NickHiderCommand;
import club.sk1er.nickhider.mixins.GuiScreenBookAccessor;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import gg.essential.api.EssentialAPI;
import gg.essential.api.commands.Command;
import gg.essential.api.utils.Multithreading;
import gg.essential.api.utils.WebUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="nick_hider", version="6.0.0", name="NickHider")
public class NickHider {
    public static final String MOD_ID = "nick_hider";
    public static final String MOD_NAME = "NickHider";
    public static final String VERSION = "6.0.0";
    @Mod.Instance(value="nick_hider")
    public static NickHider INSTANCE;
    private final Logger logger = LogManager.getLogger((String)"NickHider");
    private final Pattern newNick = Pattern.compile("We've generated a random username for you: \\s*(?<nick>\\S+)");
    private final Pattern uuidPattern = Pattern.compile("^([0-9a-f]{8})-([0-9a-f]{4})-([0-9a-f]{4})-([0-9a-f]{4})-([0-9a-f]{12})$", 2);
    private final List<Nick> nicks = new ArrayList<Nick>();
    private final List<String> namesDatabase = new ArrayList<String>();
    private final Map<String, String> cache = new HashMap<String, String>();
    private final Set<String> usedNicks = new HashSet<String>();
    private NickHiderConfig config;
    private String playerRealSkinType = "default";
    private ResourceLocation playerSkin;
    private ResourceLocation playerCape;
    private Session session;
    private GameProfile profile;
    private boolean startedLoadingSkin = false;

    public String getPseudo(String input) {
        int size;
        int pseudoHash = input.hashCode() + NickHiderConfig.pseudoKey.hashCode();
        if (pseudoHash < 0) {
            pseudoHash = -pseudoHash;
        }
        if ((size = this.namesDatabase.size()) == 0) {
            return "Player-error";
        }
        return NickHiderConfig.prefix + this.namesDatabase.get(pseudoHash % size) + NickHiderConfig.suffix + (NickHiderConfig.prefix.equalsIgnoreCase("Player-") ? "" : this.getStar());
    }

    private String getStar() {
        String star = "*";
        int starHash = star.hashCode();
        if (starHash != 42) {
            throw new IllegalStateException("Potential illegal NickHider modification found. If you did NOT edit NickHider, contact Sk1er (" + star + ")");
        }
        return star;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.session = Minecraft.func_71410_x().func_110432_I();
        if (this.session != null) {
            this.profile = this.session.func_148256_e();
        }
        if (this.profile == null) {
            this.logger.error("Profile is somehow null.");
        }
        Multithreading.runAsync(() -> {
            String wordsList = WebUtil.fetchString((String)"https://sk1er.club/words.txt");
            this.namesDatabase.addAll(Arrays.asList(Objects.requireNonNull(wordsList).split("\n")));
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.config = new NickHiderConfig();
        this.config.preload();
        EssentialAPI.getCommandRegistry().registerCommand((Command)new NickHiderCommand());
    }

    @SubscribeEvent
    public void bookCheck(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !NickHiderConfig.masterEnabled || !EssentialAPI.getMinecraftUtil().isHypixel()) {
            return;
        }
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen == null) {
            return;
        }
        if (currentScreen instanceof GuiScreenBook) {
            NBTTagList bookPages = ((GuiScreenBookAccessor)currentScreen).getBookPages();
            int currPage = ((GuiScreenBookAccessor)currentScreen).getCurrPage();
            if (currPage < bookPages.func_74745_c()) {
                try {
                    String textWithoutFormattingCodes = EnumChatFormatting.func_110646_a((String)IChatComponent.Serializer.func_150699_a((String)bookPages.func_150307_f(currPage)).func_150260_c().replace("\n", " "));
                    Matcher matcher = this.newNick.matcher(textWithoutFormattingCodes);
                    if (matcher.find()) {
                        String nick = matcher.group("nick");
                        this.remap(nick, this.profile.getName());
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to read book.", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public void chat(ClientChatReceivedEvent event) {
        if (!NickHiderConfig.masterEnabled || !EssentialAPI.getMinecraftUtil().isHypixel()) {
            return;
        }
        IChatComponent message = event.message;
        List siblings = message.func_150253_a();
        if (siblings.isEmpty()) {
            return;
        }
        for (IChatComponent component : siblings) {
            String value;
            String[] split;
            HoverEvent hoverEvent;
            ChatStyle style;
            ClickEvent clickEvent;
            if (!(component instanceof ChatComponentText) || (clickEvent = (style = component.func_150256_b()).func_150235_h()) == null || clickEvent.func_150669_a() != ClickEvent.Action.RUN_COMMAND || (hoverEvent = style.func_150210_i()) == null || hoverEvent.func_150701_a() != HoverEvent.Action.SHOW_TEXT || (split = (value = clickEvent.func_150668_b()).split(" ")).length != 2) continue;
            String uuid = split[1];
            if (!this.uuidPattern.matcher(uuid).matches()) {
                return;
            }
            try {
                CompletableFuture name = EssentialAPI.getMojangAPI().getName(UUID.fromString(uuid));
                if (name == null) {
                    return;
                }
                event.setCanceled(true);
                Minecraft mc = Minecraft.func_71410_x();
                GuiNewChat chat = mc.field_71456_v.func_146158_b();
                ((CompletableFuture)name.thenAcceptAsync(username -> mc.func_152344_a(() -> {
                    if (username != null) {
                        this.remap((String)username, this.getPseudo((String)username));
                    }
                    chat.func_146227_a(message);
                }), (Executor)Multithreading.getPool())).exceptionally(e -> {
                    mc.func_152344_a(() -> chat.func_146227_a(message));
                    return null;
                });
            }
            catch (Exception e2) {
                this.logger.error("Failed to fetch username.", (Throwable)e2);
            }
        }
    }

    @SubscribeEvent
    public void profileCheck(TickEvent.RenderTickEvent event) {
        if (!NickHiderConfig.masterEnabled || !EssentialAPI.getMinecraftUtil().isHypixel() || event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        NetHandlerPlayClient sendQueue = player.field_71174_a;
        if (sendQueue == null) {
            return;
        }
        for (NetworkPlayerInfo networkPlayerInfo : sendQueue.func_175106_d()) {
            GameProfile gameProfile = networkPlayerInfo.func_178845_a();
            String name = gameProfile.getName();
            if (gameProfile.getId() != null && gameProfile.getId().equals(this.profile.getId())) {
                if (name.equalsIgnoreCase(this.profile.getName())) continue;
                this.remap(name, this.profile.getName());
                continue;
            }
            if (!NickHiderConfig.hideOtherNames) continue;
            this.remap(name, this.getPseudo(name));
        }
    }

    public void reset() {
        this.nicks.clear();
        this.cache.clear();
        this.usedNicks.clear();
    }

    public void remap(String key, String newKey) {
        if (this.usedNicks.contains(key = key.toLowerCase(Locale.ROOT)) || key.isEmpty() || key.contains(" ")) {
            return;
        }
        this.usedNicks.add(key);
        String newName = key.length() > 2 ? newKey : key;
        Nick nick = new Nick(Pattern.compile(Pattern.quote(key), 2), key, newName);
        this.nicks.add(nick);
        Comparator<Nick> nameComparator = Comparator.comparingInt(o -> o.oldName.length());
        this.nicks.sort(nameComparator.reversed());
        this.cache.clear();
    }

    public String apply(String input) {
        if (!NickHiderConfig.masterEnabled || !NickHiderConfig.hideOwnNick || this.nicks.size() == 0) {
            return input;
        }
        if (this.cache.size() > 5000) {
            this.cache.clear();
        }
        return this.cache.computeIfAbsent(input, s -> {
            String base = input;
            for (Nick nick : this.nicks) {
                base = nick.pattern.matcher(base).replaceAll(nick.newName);
            }
            return base;
        });
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setProfile(GameProfile profile) {
        this.profile = profile;
    }

    public String out(String chat) {
        if (!NickHiderConfig.hideOwnNick) {
            return chat;
        }
        for (Nick nick : this.nicks) {
            chat = Pattern.compile(nick.newName, 2).matcher(chat).replaceAll(nick.oldName);
        }
        return chat;
    }

    public String[] tabComplete(String[] in, String soFar) {
        if (!NickHiderConfig.hideOwnNick) {
            return in;
        }
        for (int i = 0; i < in.length; ++i) {
            in[i] = this.apply(in[i]);
        }
        String[] split = soFar.split(" ");
        String tmp = split[split.length - 1];
        ArrayList<String> newNames = new ArrayList<String>();
        for (Nick nick : this.nicks) {
            if (!nick.newName.toLowerCase(Locale.ROOT).startsWith(tmp.toLowerCase(Locale.ROOT))) continue;
            newNames.add(nick.newName);
        }
        HashSet nameSet = Sets.newHashSet((Object[])in);
        nameSet.addAll(newNames);
        return nameSet.toArray(new String[0]);
    }

    public NickHiderConfig getConfig() {
        return this.config;
    }

    public String getPlayerRealSkinType() {
        return this.playerRealSkinType;
    }

    public ResourceLocation getPlayerCape() {
        return this.playerCape;
    }

    public ResourceLocation getPlayerSkin() {
        if (this.playerSkin == null && !this.startedLoadingSkin) {
            this.startedLoadingSkin = true;
            Minecraft.func_71410_x().func_152342_ad().func_152790_a(this.profile, (type, location, profileTexture) -> {
                if (type == MinecraftProfileTexture.Type.SKIN) {
                    this.playerSkin = location;
                    this.playerRealSkinType = profileTexture.getMetadata("model");
                    if (this.playerRealSkinType == null) {
                        this.playerRealSkinType = "default";
                    }
                } else if (type == MinecraftProfileTexture.Type.CAPE) {
                    this.playerCape = location;
                }
            }, true);
        }
        return this.playerSkin;
    }

    static class Nick {
        public Pattern pattern;
        public String oldName;
        public String newName;

        public Nick(Pattern pattern, String oldName, String newName) {
            this.pattern = pattern;
            this.oldName = oldName;
            this.newName = newName;
        }
    }
}

